---
generated_at: 2026-02-04 10:08:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：9-ICU ResourceBundle翻訳ファイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **ICU ResourceBundleバイナリ仕様との互換性**：ICU公式仕様との照合が未実施
  2. **PHPのIntl拡張ResourceBundleクラスでの読み込み可否**：実際の動作確認なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Translation/Dumper/IcuResFileDumper.php`（1-95行目）
- E-02: `src/Symfony/Component/Translation/Dumper/FileDumper.php`（1-101行目）
- E-03: `src/Symfony/Component/Translation/MessageCatalogue.php`（1-316行目）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（10行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IcuResFileDumperはFileDumperを継承する | E-01 21行目 `class IcuResFileDumper extends FileDumper` | ○ |
| C-02 | ファイル拡張子は"res" | E-01 91-94行目 `return 'res'` | ○ |
| C-03 | relativePathTemplateは`%domain%/%locale%.%extension%` | E-01 23行目 | ○ |
| C-04 | ヘッダーサイズは32バイト | E-01 67行目 `@32`（pack format） | ○ |
| C-05 | マジックナンバーは0xDA, 0x27 | E-01 68行目 `0xDA, 0x27` | ○ |
| C-06 | データフォーマット識別子は"ResB" | E-01 71行目 `0x52, 0x65, 0x73, 0x42` | ○ |
| C-07 | データバージョンは1.2.0.0 | E-01 72行目 `1, 2, 0, 0` | ○ |
| C-08 | Unicodeバージョンは1.4.0.0 | E-01 73行目 `1, 4, 0, 0` | ○ |
| C-09 | charサイズは2 | E-01 70行目 `20, 0, 0, 2`の最後の2 | ○ |
| C-10 | パディングは4バイト境界で0xAA | E-01 79-83行目 `str_repeat("\xAA", 4 - $padding)` | ○ |
| C-11 | リソースタイプはテーブル型(2 << 28) | E-01 58行目 `$resOffset + (2 << 28)` | ○ |
| C-12 | 値文字列はUTF-16LEエンコーディング | E-01 42行目 `mb_convert_encoding($target."\0", 'UTF-16LE', 'UTF-8')` | ○ |
| C-13 | 値文字列は長さプレフィックス付き | E-01 41行目 `pack('V', \strlen($target))` | ○ |
| C-14 | インデックスはunsigned short (pack 'v') | E-01 30行目 `pack('v', ...)` | ○ |
| C-15 | リソースオフセットはunsigned long (pack 'V') | E-01 39行目 `pack('V', ...)` | ○ |
| C-16 | getPosition()は(strlen + 28) / 4で計算 | E-01 86-88行目 | ○ |
| C-17 | メッセージカタログを2回走査 | E-01 29-32行目（第1ループ）, 38-45行目（第2ループ） | ○ |
| C-18 | pathオプションは必須 | E-02 43-45行目 | ○ |
| C-19 | PHPのIntl拡張ResourceBundleクラスで読み込み可能 | **根拠なし** | △ |
| C-20 | ICU ResourceBundleバイナリ仕様に準拠 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: PHPのIntl拡張ResourceBundleクラスでの実際の読み込みテストは未実施
  - 候補：PHPテストコード / Symfony Translation Testsディレクトリ
- C-20: ICU公式仕様書との詳細な照合は未実施
  - 候補：ICU公式ドキュメント（https://unicode-org.github.io/icu/） / ICUソースコード

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - バイナリフォーマットの互換性は外部仕様に依存しており、実装の正確性確認が重要
- 2: 高リスク - ICU ResourceBundleの仕様との整合性は、テスト等での実動作確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 生成されたresファイルがPHPのResourceBundleクラスで正しく読み込めるか確認
- [ ] ICU ResourceBundleバイナリ仕様との整合性を確認
- [ ] pack()のフォーマット指定がエンディアンとサイズの面で正しいか確認
- [ ] Symfonyの既存テストでIcuResFileDumperの動作が検証されているか確認
